texture g_MeshTexture;               // Color texture for mesh
texture g_SpecTexture;				//Specular map for guns
texture g_MeshHeightmap;               // POM heightmap
texture g_MeshLightmap;               // Lightmap for mesh 
texture g_Wavemap;                  // Normal mapp
texture g_Torchtexture;

float4x4 g_mWorldViewProjection : WORLDVIEWPROJECTION;	// World * View * Projection 
float4x4 g_mWorldView : WORLDVIEW;	          // World * View matrix
float4x4 g_mProjectionKorr;	  // World * Korr
float4 g_vMotionVec;
float4 g_CameraPosition;

float FogStart;
float FogEnd;
float Fogc;

float HDRszorzo;

float BlendFactor;

float specHardness = 10;
float specIntensity = 0.5;
float emission = 0;
float lightness = 0;

float lightIntensity;
float4 lightColor;

float resParam;
float glowInt;

bool vanNormal;

float aspect;

float lamp = 1;

float4 translation = float4(0,0,0,0);
float rotation;
float scale;

float movement;
float4 ambient = float4(0.94,0.93,0.99,1);
float4 sun = float4(1,0.95,0.94,1);
float3 sundir = normalize(float3(-1,1,0));

sampler MeshTextureSampler = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = CLAMP;
    AddressV = CLAMP; 
};

sampler MeshTextureSampler2 = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = MIRROR;
    AddressV = MIRROR; 
};

sampler MeshTextureSampler3 = 
sampler_state
{
    Texture = <g_MeshTexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler MeshLightmapSampler = 
sampler_state
{
    Texture = <g_MeshLightmap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};


sampler MeshHeightmapSampler = 
sampler_state
{
    Texture = <g_MeshHeightmap>;
    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler MeshHeightmapSampler2 = 
sampler_state
{
    Texture = <g_MeshHeightmap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;  
};

sampler WaveSampler = 
sampler_state
{
    Texture = <g_Wavemap>;
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = MIRROR;
    AddressV = MIRROR; 
};

sampler WaveTexSampler = 
sampler_state
{
    Texture = <g_Wavemap>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = WRAP;
    AddressV = WRAP; 
};

sampler TorchTextureSampler = 
sampler_state
{
    Texture = <g_Torchtexture>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = CLAMP;
    AddressV = CLAMP; 
};
float2 g_Offset[12];



//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;    
};

struct PS_INPUT
{   
    float4 TextureUV : TEXCOORD0;     
};

struct VS_OUTPUT
{   
    float4 Position  : POSITION;   
    float4 TextureUV : TEXCOORD2;
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
};

struct PS_INPUT2
{   
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float4 TextureUV : TEXCOORD2;    
};

struct VS_INPUT_POM
{
    float4 Position  : POSITION;    
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float4 normal    : NORMAL;    
    float4 tangent   : TANGENT0;
    float4 binormal  : BINORMAL0;
};

struct PS_INPUT_POM
{   
    float  Fog       : FOG;
    float4 Position  : POSITION;
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float3 ray    : TEXCOORD2;    
};

struct PS_INPUT_METAL
{   
    float  Fog       : FOG;
    float4 Position  : POSITION;
    float2 TexUV1    : TEXCOORD0;
    float2 TexUV2    : TEXCOORD1;
    float3 normal    : TEXCOORD2;  
    float3 tangent    : TEXCOORD3;
    float3 binormal    : TEXCOORD4;
    float3 worldPosition  : TEXCOORD5;	
};


//--------------------------------------------------------------------------------------
// Full screen glow
//--------------------------------------------------------------------------------------


PS_OUTPUT FullScreenGlowPS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;
	
	float treshold = 0.75;
	float4 tex = float4(treshold,treshold,treshold,treshold);
	
	tex = max(tex,0.11* tex2D(MeshTextureSampler, In.TextureUV));
	
	glowInt = 11;
	resParam = 0.7;
	
	tex = max(tex,glowInt * 0.098 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.002,0.0005)*resParam)); 
	tex = max(tex,glowInt * 0.098 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.002,-0.0005)*resParam)); 
	tex = max(tex,glowInt * 0.098 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.0005,0.002)*resParam)); 
	tex = max(tex,glowInt * 0.098 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.0005,-0.002)*resParam)); 
	
	tex = max(tex,glowInt * 0.075 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.004,-0.0005)*resParam)); 
	tex = max(tex,glowInt * 0.075 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.004,0.0005)*resParam)); 
	tex = max(tex,glowInt * 0.075 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.0005,0.004)*resParam)); 
	tex = max(tex,glowInt * 0.075 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.0005,-0.004)*resParam)); 

	tex = max(tex,glowInt * 0.065 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.005,0.001)*resParam)); 
	tex = max(tex,glowInt * 0.065 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.005,-0.001)*resParam)); 
	tex = max(tex,glowInt * 0.065 * tex2D(MeshTextureSampler, In.TextureUV+float2(-0.001,0.005)*resParam)); 
	tex = max(tex,glowInt * 0.065 * tex2D(MeshTextureSampler, In.TextureUV+float2(0.001,-0.005)*resParam)); 
	
	tex -=float4(treshold,treshold,treshold,treshold);
    
	//flat módon kicsit szar lenne
	//valami "random" mód kéne
	
	Output.RGBColor = tex2D(MeshTextureSampler, In.TextureUV) + pow(tex*1.1,2);
	
    return Output;
}

/*

PS_OUTPUT FullScreenGlowPS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float4 ertek;
    float4 tex=tex2D(MeshTextureSampler, In.TextureUV);
    Output.RGBColor  = 0 ;// tex2D(MeshTextureSampler, In.TextureUV);
    ertek=tex+0.5;

	for(int i=0; i < 12; i++ )
	{
          
          Output.RGBColor += max(0,tex2D(MeshTextureSampler,In.TextureUV + g_Offset[i])-ertek);
       
	}  

    Output.RGBColor =Output.RGBColor/10;
    return Output;
}*/


//--------------------------------------------------------------------------------------
// Full screen red-grey-stuff.
//--------------------------------------------------------------------------------------


PS_OUTPUT FullScreenGreyscalePS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float3 tex=tex2D(MeshTextureSampler, In.TextureUV);
    float2 ujUV = In.TextureUV-0.5;
    float tav =1.3-sqrt(ujUV.x*ujUV.x+ujUV.y*ujUV.y);
    float szurk=(tex.r+tex.g+tex.b)*2*tav-1.2;
    szurk=saturate(szurk);
    float4 vegso;
    vegso.r = szurk;
    szurk = szurk*szurk;
    vegso.g = szurk;
    vegso.b = szurk;
    vegso.a = saturate(pow(length(In.TextureUV-float2(0.5,0.5)),2)-0.5+BlendFactor); //In.TextureUV.x; // BlendFactor
    Output.RGBColor  = vegso;
    
    return Output;
}


//--------------------------------------------------------------------------------------
// Full screen motion blur
//--------------------------------------------------------------------------------------


PS_OUTPUT MotionBlurPS( PS_INPUT In) 
{ 
    PS_OUTPUT Output;  
    float2 vOffset;
    float2 vPrecomp=(In.TextureUV.xy-0.5)*g_vMotionVec.z+g_vMotionVec.xy;
    vPrecomp*=0.01;
    float fKill= vPrecomp.x*vPrecomp.x+vPrecomp.y*vPrecomp.y;
    clip(fKill-0.00000015);
    Output.RGBColor = 0;
    for(int i=0; i < 8; i++ )
    {
          vOffset=vPrecomp*i;     
          Output.RGBColor += tex2D(MeshTextureSampler,In.TextureUV + vOffset)*(8-i);
       
	}    
    Output.RGBColor = Output.RGBColor/36;
    return Output;
}


//--------------------------------------------------------------------------------------
// Simple Water reflection shader
//--------------------------------------------------------------------------------------

VS_OUTPUT WaterReflectionVS( float4 vPos : POSITION, 
                         float4 vTexCoord0 : TEXCOORD0,
                         float4 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;
  
    Output.Position = mul(vPos, g_mWorldViewProjection);
   
    Output.TextureUV = mul(vPos, g_mWorldView);
    
    Output.TexUV1 = vTexCoord0;
    Output.TexUV2 = vTexCoord1;
    return Output;    
}


PS_OUTPUT WaterReflectionPS( VS_OUTPUT In) 
{ 
    PS_OUTPUT Output; 
    float4 reflvec=tex2D(WaveTexSampler,In.TexUV1)+tex2D(WaveTexSampler,In.TexUV2)-1;
    reflvec.w=0;

    float3 ref2=mul(reflvec.xzyw,g_mWorldView);
    float3 ev=normalize(In.TextureUV.xyz);
    float fresnel=dot(ref2,ev)+1;

    reflvec.z=0;
    float4 hova=In.TextureUV+reflvec;

    hova=mul(hova,g_mProjectionKorr);
    float4 vizcol={0.25,0.6,0.8,1};
        Output.RGBColor=lerp(tex2Dproj(MeshTextureSampler2,hova),vizcol,0.2);
    Output.RGBColor.a=fresnel*0.6;
  
    return Output;
}

PS_INPUT_METAL ShineVS ( VS_INPUT_POM In)
{
PS_INPUT_METAL Output;

	
    Output.worldPosition = (float3)In.Position;
	Output.Position= mul(In.Position, g_mWorldViewProjection);
    Output.normal  = normalize((float3)In.normal);
	Output.tangent  = normalize((float3)In.tangent);
	Output.binormal  = normalize((float3)In.binormal);
    Output.TexUV1  = In.TexUV1;
    Output.TexUV2  = In.TexUV2;
    Output.Fog = 1- saturate((Output.Position.z-FogStart)/(FogEnd-FogStart));   
    return Output;

}


PS_OUTPUT ShinePS( PS_INPUT_METAL In) 
{
	PS_OUTPUT Output;
	
	float3 cv = g_CameraPosition-In.worldPosition;
	float3 refl;
	
	float3 n = float3(0,0,0);
	if (vanNormal)
	{
		float3 normtex = tex2D(MeshHeightmapSampler2,In.TexUV1).xyz-float3(0.5,0.5,0.5);
		n = normtex.x * In.tangent + normtex.y * In.normal + normtex.z * In.binormal;	
	}
	
	refl = normalize(reflect(cv,In.normal+n));
	//float shine = pow(max(0,dot(refl,sundir)),specHardness);

	float ambientpow = 0.01;
	float sunpow = 0.96;
	
	float4 kdtex = tex2D(MeshTextureSampler3,In.TexUV1);
	float4 lmap = tex2D(MeshLightmapSampler,In.TexUV2) * HDRszorzo;
	
	float li;
	if (lightIntensity>0)
		li = lightIntensity *
		max(0,10-distance(g_CameraPosition,In.worldPosition))/15*max(0,dot(normalize(cv),normalize(In.normal+n)));
	
    Output.RGBColor  = 
	kdtex* (
		(ambient*ambientpow+min(lmap,0.5))+  			//ambient
		(max(lmap-0.3,0)*1.42*pow(max(0,dot(-refl,sundir)),specHardness)*specIntensity)*Fogc+	//specular
		(lightColor*max(li,pow(li,specHardness)*specIntensity))		//point light
	)+	
		min(pow(kdtex+0.5,3),1)	*	(max(lmap-0.5,0)*sun*sunpow*max(0,dot(sundir,In.normal+n)));
	
	Output.RGBColor.a = kdtex.a;
	
	
	
	/*
    Output.RGBColor  = tex2D(MeshTextureSampler3,In.TexUV1)*(tex2D(MeshLightmapSampler,In.TexUV2)*(HDRszorzo+max(0,-dot(In.normal+n,sundir)/5)*Fogc+shine*specIntensity*Fogc)+lightColor*lightIntensity*max(0,10-distance(g_CameraPosition,In.worldPosition))/15*max(0,dot(normalize(cv),normalize(In.normal+n))));
	*/
    return Output;
}

/*
PS_OUTPUT ShinePS( PS_INPUT_METAL In) 
{
	PS_OUTPUT Output;
	
	float3 cv = g_CameraPosition-In.worldPosition;
	float3 refl;
	
	float3 n = float3(0,0,0);
	if (vanNormal)
	{
		float3 normtex = tex2D(MeshHeightmapSampler2,In.TexUV1).xyz-float3(0.5,0.5,0.5);
		n = normtex.x * In.tangent + normtex.y * In.normal + normtex.z * In.binormal;	
	}
	
	refl = normalize(reflect(cv,In.normal+n));
	
	float4 ambient = float4(0.94,0.93,0.99,1);
	float4 sun = float4(1,0.95,0.94,1);
	float3 sundir = normalize(float3(-1,1,0));
	float ambientpow = 0.26;
	float sunpow = 1.02;
	
	float4 kdtex = tex2D(MeshTextureSampler3,In.TexUV1);
	float4 lmap = tex2D(MeshLightmapSampler,In.TexUV2);
	
    Output.RGBColor  = 
	kdtex*			(ambient*ambientpow+max(lmap,0.5))+
	pow(kdtex,0.3)*	(max(lmap-0.5,0)*sun*sunpow*max(0,dot(sundir,In.normal+n)))+
	(kdtex/2+0.5)*	(pow(max(0,dot(-refl,sundir)),specHardness)*specIntensity);
						

    return Output;
}*/


PS_INPUT_METAL PropVS ( VS_INPUT_POM In)
{

PS_INPUT_METAL Output;

	float4 normal = In.normal;
	float4 pos = In.Position;
	if (rotation!=0)
	{
    normal.x = In.normal.x*cos(rotation)-In.normal.z*sin(rotation);
    normal.z = In.normal.x*sin(rotation)+In.normal.z*cos(rotation);
    pos.x = In.Position.x*cos(rotation)-In.Position.z*sin(rotation);
    pos.z = In.Position.x*sin(rotation)+In.Position.z*cos(rotation);
	}
  pos.x*=scale;
  pos.y*=scale;
  pos.z*=scale;
  
	pos += translation;
  Output.worldPosition = (float3)pos;
  Output.Position= mul(pos, g_mWorldViewProjection);
  Output.normal  = normalize((float3)normal);
  Output.tangent  = normalize((float3)In.tangent);
  Output.binormal  = normalize((float3)In.binormal);
  Output.TexUV1  = In.TexUV1;
  Output.TexUV2  = In.TexUV2;
  Output.Fog = 1- saturate((Output.Position.z-FogStart)/(FogEnd-FogStart));
  //Output.Fog = 1;
  return Output;
}


PS_OUTPUT PropPS( PS_INPUT_METAL In) 
{
  PS_OUTPUT Output;
  float4 kdtex = tex2D(MeshTextureSampler3,In.TexUV1);
  Output.RGBColor  = kdtex * (lightness * max(0,dot(In.normal,sundir)-0.3)+ ambient*0.5 + emission);
  Output.RGBColor.a = kdtex.a;

  return Output;
}



PS_INPUT_POM ParallaxOcclusionVS( VS_INPUT_POM In) 
{ 
    PS_INPUT_POM Output;
    float3 rayws = g_CameraPosition-In.Position;
    float3 ray;
    ray.y = -dot(rayws,In.tangent);
    ray.x = dot(rayws,In.binormal);
    ray.z = dot(rayws,In.normal);
    

    Output.Position= mul(In.Position, g_mWorldViewProjection);
   if (ray.z>0)
   {
    ray.z += 0.3;
   }else
   {
    ray.z = 0.1-ray.z;
   };
    //ray=normalize(ray);
   // ray.z= max(0,ray.z*10);
    ray.z=ray.z*10;
    Output.ray  = ray;
    Output.TexUV1  = In.TexUV1;
    Output.TexUV2  = In.TexUV2;
    Output.Fog = 1- saturate((Output.Position.z-FogStart)/(FogEnd-FogStart));   
 
    return Output;
}

PS_OUTPUT ParallaxOcclusionPS( PS_INPUT_POM In) 
{ 
    PS_OUTPUT Output;
    float2 texpos=In.TexUV1;
    
    float3 ray=In.ray/In.ray.z;
    float3 currpos;
    float3 texmin;
    texmin.xy = texpos.xy - ray.xy*0.5;
    texmin.z=0;

    currpos = texmin;

    ray=ray/7;


    float elozo;
    float kovetkezo=tex2D(MeshHeightmapSampler2,currpos).r;
    float doles=1;
    float kul=0;
    float kul2;

    for (int i=0; i<7; i++)
    { 
       currpos=currpos+ray;
      elozo=kovetkezo;
      kovetkezo=tex2D(MeshHeightmapSampler2,currpos).r;
      kul2=elozo-currpos.z;

      if (kul2>0)
      { 
       texmin=currpos;
       kul=kul2;
       doles=elozo-kovetkezo+ray.z;
      };            
    };
    
    texmin=texmin+ray*(kul/doles);
    Output.RGBColor  = tex2D(MeshTextureSampler3,texmin)*tex2D(MeshLightmapSampler,In.TexUV2)*HDRszorzo;

    return Output;
}



technique FullScreenGlow
{
    pass P0
    {
        PixelShader  = compile ps_2_0 FullScreenGlowPS(); 
    }
}

technique FullScreenGreyscale
{
    pass P0
    {
        PixelShader  = compile ps_2_0 FullScreenGreyscalePS(); 
    }
}

technique MotionBlur
{
    pass P0
    {
        PixelShader  = compile ps_2_0 MotionBlurPS(); 
    }
}


technique WaterReflection
{
    pass P0
    {
        VertexShader = compile vs_2_0 WaterReflectionVS(); 
        PixelShader  = compile ps_2_0 WaterReflectionPS(); 
    }
}

technique ParallaxOcclusion
{
    pass P0
    {   
        VertexShader = compile vs_2_0 ParallaxOcclusionVS();
        PixelShader  = compile ps_2_0 ParallaxOcclusionPS(); 
    }
}

technique Shine
{
    pass P0
    {   
        VertexShader = compile vs_2_0 ShineVS();
        PixelShader  = compile ps_2_0 ShinePS(); 
    }
}

technique Prop
{
    pass P0
    {   
        VertexShader = compile vs_2_0 PropVS();
        PixelShader  = compile ps_2_0 PropPS(); 
    }
}